

#ifndef USE_ATLASING
		SPECIALISATION_PARAM( useAtlasing, "Use atlasing?", "USE_ATLASING" )	// TRUE if the environment map is to be used	
#		if defined( _3DSMAX_ ) || defined( USE_ATLASING )
			DEPENDENT_FLOAT4_PARAM( texAtlasUV01, texAtlasU0, texAtlasV0, texAtlasU1, texAtlasV1, "AtlasU0", "AtlasV0", "AtlasU1", "AtlasV1", useAtlasing )
#		endif
#else
		static const bool useAtlasing = true;
		FLOAT4_PARAM( texAtlasUV01, texAtlasU0, texAtlasV0, texAtlasU1, texAtlasV1, "AtlasU0", "AtlasV0", "AtlasU1", "AtlasV1" )  
#endif

float2 texCoord2DAtlas( float2 uv, float2 atlasXY )
{
	DEPENDENT_CODE_START( useAtlasing )
#if defined( _3DSMAX_ ) || defined( USE_ATLASING )
	DECLARE_MERGED_FLOAT4_PARAM( texAtlasUV01, texAtlasU0, texAtlasV0, texAtlasU1, texAtlasV1 )
	float2 offset = atlasXY * texAtlasUV01.zw;
	float4 uv01 = texAtlasUV01 + offset.xyxy;
	
	float2 result = lerp( uv01.xy, uv01.zw, uv );
#if defined( _3DSMAX_ )
	result.y -= 1-texAtlasUV01.w;
#endif
	
	return result;
#endif
	DEPENDENT_CODE_ELSE( useAtlasing )
#if defined( _3DSMAX_ ) || !defined( USE_ATLASING )
	return uv;
#endif
	DEPENDENT_CODE_END( useAtlasing )	
}

float2 texCoord2DAtlas( float2 uv, float atlasYMulColumnsPlusX )
{
	DEPENDENT_CODE_START( useAtlasing )
#if defined( _3DSMAX_ ) || defined( USE_ATLASING )
	DECLARE_MERGED_FLOAT4_PARAM( texAtlasUV01, texAtlasU0, texAtlasV0, texAtlasU1, texAtlasV1 )
	float u = atlasYMulColumnsPlusX * texAtlasUV01.z;
	float bias = 1.0/102400.0;
	float biasedU = u + bias;
	float v = floor( biasedU ) * texAtlasUV01.w;
	u = frac(biasedU);
	float4 uv01 = texAtlasUV01 + float4( u, v, u, v );
	float2 result = lerp( uv01.xy, uv01.zw, uv );
#if defined( _3DSMAX_ )
	result.y -= 1-texAtlasUV01.w;
#endif

	return result;
#endif
	DEPENDENT_CODE_ELSE( useAtlasing )
#if defined( _3DSMAX_ ) || !defined( USE_ATLASING )
	return uv;
#endif
	DEPENDENT_CODE_END( useAtlasing )	
}


// this version is used in geninstanced shaders
float4 tex2DAtlas( sampler2D s, float2 uv, float2 atlasXY )
{
	return tex2D( s, texCoord2DAtlas(uv, atlasXY) );
}

// this is plain version, it will just sample the sub texture defined by the texAtlas?? variables
float4 tex2DAtlas( sampler2D s, float2 uv )
{
	return tex2DAtlas( s, uv, float2( 0.0, 0.0 ) );
}

// this version is used in geninstanced shaders
float4 tex2DAtlas( sampler2D s, float2 uv, float atlasYMulColumnsPlusX )
{
	return tex2D( s, texCoord2DAtlas(uv, atlasYMulColumnsPlusX) );
}
